/*
 * Decompiled with CFR 0.152.
 */
package com.shasratech.vts;

import com.shasratech.vts.AES;
import com.shasratech.vts.Globals;
import com.shasratech.vts.SQLiteHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

public class HTTPClient_Get
extends Thread {
    String Customer_ID;
    String Last_Data_DownLoad_Time;

    @Override
    public void run() {
        this.Customer_ID = SQLiteHandler.Get_Var_Val_from_SysConf("Feature", "Customer_ID");
        if (this.Customer_ID != null && !this.Customer_ID.isEmpty()) {
            this.Customer_ID = AES.decrypt(this.Customer_ID, Globals.AES_Secret_Key);
        }
        if (this.Customer_ID == null || this.Customer_ID.isEmpty()) {
            System.out.println("Customer_ID | Last_Data_DownLoad_Time Not Found\n\nReturning ");
            Globals.ErrMsgDialog("Customer_ID | Last_Data_DownLoad_Time Not Found\n\nReturning ");
        }
        this.Last_Data_DownLoad_Time = SQLiteHandler.Get_Var_Val_from_SysConf("HTTP", "Last_Data_DownLoad_Time");
        if (this.Last_Data_DownLoad_Time == null || this.Last_Data_DownLoad_Time.isEmpty()) {
            this.Last_Data_DownLoad_Time = "2018-01-01 00:00:00";
        }
        this.Last_Data_DownLoad_Time = this.Last_Data_DownLoad_Time.replace(" ", "%20");
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(HTTPClient_Get.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        while (true) {
            long l = System.currentTimeMillis();
            this.Get_Data_from_Server();
            long l2 = System.currentTimeMillis();
            l2 -= l;
            l = 60000L - (l2 %= 60000L);
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(HTTPClient_Get.class.getName()).log(Level.SEVERE, null, interruptedException);
                continue;
            }
            break;
        }
    }

    private void Get_Data_from_Server() {
        try {
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            if (this.Customer_ID == null || this.Customer_ID.isEmpty()) {
                System.out.println("Customer_ID | Last_Data_DownLoad_Time Not Found\n\nReturning ");
                return;
            }
            String string = "http://shasratech.com/Products/VTS/DD.php?CID=" + this.Customer_ID + "&MinTime=" + this.Last_Data_DownLoad_Time + "&CSV=1";
            HttpGet httpGet = new HttpGet(string);
            httpGet.addHeader("accept", "application/text");
            CloseableHttpResponse closeableHttpResponse = defaultHttpClient.execute((HttpUriRequest)httpGet);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + closeableHttpResponse.getStatusLine().getStatusCode());
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(closeableHttpResponse.getEntity().getContent()));
            String string2 = "";
            String string3 = bufferedReader.readLine();
            while (string3 != null) {
                string2 = string2 + string3;
                string3 = bufferedReader.readLine();
            }
            if (!string2.isEmpty()) {
                this.Process_HTTP_Response(string2);
            }
            defaultHttpClient.getConnectionManager().shutdown();
        }
        catch (ClientProtocolException clientProtocolException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void Process_HTTP_Response(String string) {
        String[] stringArray = string.split("<br>");
        int n = stringArray.length;
        String string2 = "";
        for (int i = 0; i < n; ++i) {
            String string3;
            String string4;
            String[] stringArray2 = stringArray[i].split(",");
            if (stringArray2.length < 12) {
                string4 = "Invalid Input from HTTP: \n" + stringArray[i] + "\nSkipping";
                Globals.AppendData2File(Globals.SystemLogFile, string4, true, false);
                continue;
            }
            string4 = stringArray2[3];
            if (!this.Customer_ID.equals(string4)) {
                string3 = "Customer ID does not Match: Configured = [" + this.Customer_ID + "],  Received = [" + string4 + "]\t Not Processing ts[a]";
                Globals.AppendData2File(Globals.SystemLogFile, string3, true, false);
                continue;
            }
            string2 = stringArray2[1];
            string3 = stringArray2[2];
            String string5 = stringArray2[4];
            String string6 = stringArray2[5];
            String string7 = stringArray2[7];
            String string8 = stringArray2[8];
            String string9 = stringArray2[9];
            String string10 = stringArray2[10];
            String string11 = stringArray2[11];
            String string12 = SQLiteHandler.Get_Val_from_DB("Vehicle", "TareWeight", "", "ID_Number = '" + string5 + "' and Disabled = 'NO'");
            int n2 = Globals.String2Int(string12);
            int n3 = Globals.String2Int(string11);
            int n4 = 10;
            String[] stringArray3 = new String[6];
            if (!this.Get_Best_Site_for_Latitude_Longitude(string7, string8, string9, stringArray3)) continue;
            String string13 = stringArray3[2];
            String string14 = stringArray3[3];
            String string15 = stringArray3[4];
            String string16 = stringArray3[5];
            String string17 = "SALE";
            if (string15.equals("SUPPLIER")) {
                string17 = "PURCHASE";
            }
            boolean bl = false;
            if (n2 > 0 && n3 > 0 && n3 >= n2 * (100 - n4) / 100 && n3 <= n2 * (100 + n4) / 100) {
                bl = true;
            }
            if (bl) {
                if (!string17.equals("PURCHASE")) continue;
                SQLiteHandler.Update_field_in_DB_Number("Vehicle", "TareWeight", string11, "ID_Number = '" + string5 + "'");
                continue;
            }
            if (n3 <= 0) continue;
            int n5 = Globals.String2Int(string16);
            int n6 = (n3 - n2) * n5 / 1000;
            Globals.Insert_Update_into_Transactions_Ordered("", 0, string5, string17, bl ? "YES" : "NO", "CREDIT", string9, n3, n2, n3 - n2, n5, n6, 0.0, n6, 0.0, n6, string14, string6, string13, "-", "DCNum", string6 + " , Though Net", string3, "-", "-", false, 0.0, 0.0, 0.0, "Through Net", 0.0, "");
            boolean bl2 = false;
            Globals.AddEntry2_Account_Table_QTD_External_VTS(string9, string14, n3, n2, string17.equals("SALE"), true, "-", "-", string13, 0.0, 0.0, n5, n6, 0.0, n6, string3, "", "0", "0", "0", 0.0, bl2);
        }
        if (!string2.isEmpty()) {
            this.Last_Data_DownLoad_Time = string2 = Globals.Add_Secs_Time_String(string2, 1);
            SQLiteHandler.InUp2_Sysconf_T("HTTP", "Last_Data_DownLoad_Time", string2);
            this.Last_Data_DownLoad_Time = this.Last_Data_DownLoad_Time.replace(" ", "%20");
        }
    }

    boolean Get_Best_Site_for_Latitude_Longitude(String string, String string2, String string3, String[] stringArray) {
        String string4;
        String[] stringArray2;
        String string5 = string.substring(0, 4);
        String string6 = string2.substring(0, 4);
        String string7 = "Select Latitude, Longitude,Name, Owner, Type from Site where Latitude like '" + string5 + "%' and Longitude like  '" + string6 + "%'";
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.clear();
        SQLiteHandler.RunQueryOnce(string7, arrayList);
        int n = arrayList.size();
        if (n < 1) {
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        double d = 9000.0;
        double d2 = 9000.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n4 = -1;
        String string8 = "";
        char c = '\u0007';
        string8 = string8 + c;
        for (int i = 0; i < n; ++i) {
            stringArray2 = ((String)arrayList.get(i)).split(string8, -1);
            string4 = stringArray2[0];
            String string9 = stringArray2[1];
            d3 = Double.parseDouble(string);
            d4 = Double.parseDouble(string2);
            d5 = Double.parseDouble(string4);
            d6 = Double.parseDouble(string9);
            if (Math.abs(d3 - d5) < d) {
                d = Math.abs(d3 - d5);
                n2 = i;
            }
            if (!(Math.abs(d4 - d6) < d2)) continue;
            d2 = Math.abs(d4 - d6);
            n3 = i;
        }
        n4 = n2 == n3 ? n2 : (d < d2 ? n2 : n3);
        stringArray2 = ((String)arrayList.get(n4)).split(string8, -1);
        string4 = SQLiteHandler.Get_Val_from_DB("Site", "Rate", "", "Owner = '" + stringArray2[3] + "' and Name = '" + stringArray2[2] + "' and Material = '" + string3 + "'");
        stringArray[0] = stringArray2[0];
        stringArray[1] = stringArray2[1];
        stringArray[2] = stringArray2[2];
        stringArray[3] = stringArray2[3];
        stringArray[4] = stringArray2[4];
        stringArray[5] = string4;
        return true;
    }
}

