/*
 * Decompiled with CFR 0.152.
 */
package com.shasratech.vts;

import com.shasratech.vts.Arduino_MC_Message_Type;
import com.shasratech.vts.Globals;
import com.shasratech.vts.Main;
import java.util.logging.Level;
import java.util.logging.Logger;
import jssc.SerialPort;
import jssc.SerialPortException;

class MC_Thread
extends Thread {
    byte[] buffer = null;
    String Local_Buffer = "";
    boolean In_readData_MC = false;
    int my_RFID_Reader_Timer = 0;
    SerialPort serPort = null;
    boolean Serport_Opened = false;
    int my_Sl_Num = -1;

    public MC_Thread(int n) {
        this.my_Sl_Num = n;
    }

    @Override
    public void run() {
        System.out.println("abcd 2134234 Starting MC Port");
        try {
            MC_Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            Logger.getLogger(MC_Thread.class.getName()).log(Level.SEVERE, null, interruptedException);
        }
        if (Globals.MC_Num > 0) {
            this.serPort = new SerialPort(Globals.MC_PortName[this.my_Sl_Num]);
            try {
                this.serPort.openPort();
                System.out.println("MC Serail Read Port Opened");
                try {
                    this.serPort.setParams(Globals.Get_BaudRate(Globals.MC_Baud_Rate[this.my_Sl_Num]), Globals.Get_DataBits(Globals.MC_Data_Bits[this.my_Sl_Num]), Globals.Get_StopBits(Globals.MC_Stop_Bits[this.my_Sl_Num]), Globals.Get_Parity(Globals.MC_Parity[this.my_Sl_Num]));
                    System.out.println("MC Serail Read Port Params");
                    this.Process_MC_Data();
                    long l = 0L;
                    long l2 = 0L;
                    while (Globals.serial_MC_T_Run_This_Thread) {
                        int n;
                        l = Globals.Get_Current_Date_Time_millis_L();
                        try {
                            MC_Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            Logger.getLogger(MC_Thread.class.getName()).log(Level.SEVERE, null, interruptedException);
                        }
                        while ((n = this.serPort.getInputBufferBytesCount()) > 0) {
                            this.buffer = this.serPort.readBytes(n);
                            if (Main.myMainwindow != null && Main.myMainwindow.myArduino != null) {
                                Main.myMainwindow.myArduino.Update_Data_into_Serial_Display(this.my_Sl_Num, this.buffer);
                            }
                            for (int i = 0; i < this.buffer.length; ++i) {
                                this.Local_Buffer = this.Local_Buffer + (char)this.buffer[i];
                            }
                            System.out.println("Local_Buffer = " + this.Local_Buffer);
                        }
                        if (!this.Local_Buffer.isEmpty()) {
                            this.Process_MC_Data();
                        }
                        if ((long)this.my_RFID_Reader_Timer > (l2 = Globals.Get_Current_Date_Time_millis_L() - l)) {
                            this.my_RFID_Reader_Timer = (int)((long)this.my_RFID_Reader_Timer - l2);
                            continue;
                        }
                        this.my_RFID_Reader_Timer = 0;
                    }
                }
                catch (SerialPortException serialPortException) {
                    Logger.getLogger(MC_Thread.class.getName()).log(Level.SEVERE, null, serialPortException);
                    System.out.println("Starting Serail Read Port Set Params Failed");
                }
            }
            catch (SerialPortException serialPortException) {
                Logger.getLogger(MC_Thread.class.getName()).log(Level.SEVERE, null, serialPortException);
                System.out.println("MC Serail Read Port Open Failed");
            }
        }
    }

    void Process_MC_Data() {
        if (this.Local_Buffer.contains("FPA_1_ENTRY")) {
            this.Local_Buffer = "";
            Globals.ErrMsgDialog("Please \n\nKEEP\n\n the Finger on Finger Print Reader");
        }
        if (this.Local_Buffer.contains("FPA_REMOVE_FINGER")) {
            this.Local_Buffer = "";
            Globals.ErrMsgDialog("Please \n\nREMOVE\n\n the Finger\nfrom Finger Print Reader");
        }
        if (this.Local_Buffer.contains("FPA_2_ENTRY")) {
            this.Local_Buffer = "";
            Globals.ErrMsgDialog("Please \n\nKEEP AGAIN [2]\n\n the Finger\non Finger Print Reader");
        }
        if (this.Local_Buffer.contains("FPA_ENROLL_SUCCESS")) {
            this.Local_Buffer = "";
        }
        if (this.Local_Buffer.contains("FPA_FINGER_DETECTED") || this.Local_Buffer.contains("FPA_ERR_NOT_FOUND")) {
            this.Local_Buffer = "";
        }
        if (this.Local_Buffer.contains("FPA_ENROLL_DELETED")) {
            this.Local_Buffer = "";
        }
        if (this.Local_Buffer.contains("FPA_ERR")) {
            Globals.ErrMsgDialog("ERROR:: " + Globals.Get_Current_Date_Time() + "\n\n" + this.Local_Buffer);
            this.Local_Buffer = "";
        }
        if (this.Local_Buffer.contains("Firmware Version")) {
            this.Local_Buffer = "";
            this.Serport_Opened = true;
            Globals.Send_Red_Signal(true);
            Globals.Send_Green_Signal(true);
        }
        if (this.Local_Buffer.contains("RFID_UID")) {
            if (this.my_RFID_Reader_Timer > 1) {
                System.out.println("Waiting for RFID_Reader_Timer");
            } else {
                this.my_RFID_Reader_Timer = Globals.my_RFID_Reader_Timer_Wait_Time_MSec;
                Globals.RFID_UID_Vehicle_Detection(this.my_Sl_Num, this.Local_Buffer);
            }
            this.Local_Buffer = "";
        }
    }

    public void WriteData_2_MC(int n, byte[] byArray, int n2, Arduino_MC_Message_Type arduino_MC_Message_Type) {
        if (n != this.my_Sl_Num) {
            return;
        }
        if (!this.Serport_Opened) {
            System.out.println("Serport Not Opened.\nReturning...");
            return;
        }
        long l = Globals.Get_Current_Date_Time_millis_L();
        for (int i = 0; i < n2; ++i) {
            try {
                this.serPort.writeByte(byArray[i]);
                try {
                    MC_Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(MC_Thread.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
                continue;
            }
            catch (SerialPortException serialPortException) {
                Logger.getLogger(MC_Thread.class.getName()).log(Level.SEVERE, null, serialPortException);
            }
        }
        long l2 = Globals.Get_Current_Date_Time_millis_L() - l;
        this.my_RFID_Reader_Timer = (long)this.my_RFID_Reader_Timer > l2 ? (int)((long)this.my_RFID_Reader_Timer - l2) : 0;
    }
}

