/*
 * Decompiled with CFR 0.152.
 */
package com.shasratech.vts;

import com.shasratech.vts.AES;
import com.shasratech.vts.AutoSaveCompare;
import com.shasratech.vts.Globals;
import com.shasratech.vts.SQLiteHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Periodic_DB_Ops
extends Thread {
    private boolean myTrhead_running = false;
    int Secs = Globals.String2Int(Globals.Get_Current_Date_Time());

    public Periodic_DB_Ops() {
        this.Secs %= 86400;
        Globals.Periodic_DB_Ops_T_Run_This_Thread = true;
    }

    public void Stop_This_Thread() {
        Globals.Periodic_DB_Ops_T_Run_This_Thread = false;
    }

    @Override
    public void run() {
        if (!Globals.Periodic_Full_Backup_Enabled && !Globals.Periodic_Incremental_Backup_Enabled) {
            return;
        }
        while (Globals.Periodic_DB_Ops_T_Run_This_Thread) {
            while (this.myTrhead_running && Globals.Periodic_DB_Ops_T_Run_This_Thread) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger(AutoSaveCompare.class.getName()).log(Level.SEVERE, null, interruptedException);
                }
            }
            this.TimeSlice_Schedule();
            try {
                for (int i = 602; Globals.Periodic_DB_Ops_T_Run_This_Thread && i > 2 && !Globals.Force_Perioc_Full_Backup_Now && !Globals.Force_Perioc_Incremental_Backup_Now; --i) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                Logger.getLogger(AutoSaveCompare.class.getName()).log(Level.SEVERE, null, interruptedException);
            }
        }
    }

    private void TimeSlice_Schedule() {
        if (Globals.Force_Perioc_Full_Backup_Now) {
            Periodic_DB_Ops.Encrypt_DB_Full_Backup();
            Globals.Force_Perioc_Full_Backup_Now = false;
            return;
        }
        if (Globals.Force_Perioc_Incremental_Backup_Now) {
            String string = SQLiteHandler.Get_Var_Val_from_SysConf("Database", "Last_Incremental_BackupTime_S");
            Globals.Encrypt_DB_Incremental_Backup(string);
            Globals.Force_Perioc_Incremental_Backup_Now = false;
            return;
        }
        this.myTrhead_running = true;
        this.Take_Regular_Full_Backup();
        this.Take_Regular_Incremental_Backup();
        this.Delete_DB_Regularly();
        this.myTrhead_running = false;
    }

    public static boolean Encrypt_DB_Full_Backup() {
        String string = Globals.DB_Source_Dir + "\\" + Globals.DB_Name + ".db";
        File file = new File(string);
        String string2 = Globals.DB_Backup_Dir + "\\" + Globals.Get_Current_Date_Time(Globals.File_Date_Time_Format_3Mon) + "-Full-temp.en";
        File file2 = new File(string2);
        boolean bl = false;
        if (file.exists()) {
            bl = AES.FileEncrypt(string, string2, Globals.AES_Secret_Key);
            if (!Globals.Force_Perioc_Full_Backup_Now) {
                String string3 = Globals.Get_Current_Date_Time();
                SQLiteHandler.InUp2_Sysconf_T("Database", "Last_Full_BackupTime_S", string3);
            }
        }
        return bl;
    }

    private void Take_Regular_Full_Backup() {
        if (!Globals.Periodic_Full_Backup_Enabled && !Globals.Force_Perioc_Full_Backup_Now) {
            return;
        }
        Date date = null;
        Date date2 = new Date();
        String string = SQLiteHandler.Get_Var_Val_from_SysConf("Database", "Last_Full_BackupTime_S");
        date = string == null || string.isEmpty() ? Globals.String2Date(Globals.Add_Secs_Time_String(Globals.Get_Current_Date_Time(), -86400)) : Globals.String2Date(string);
        long l = (date2.getTime() - date.getTime()) / 1000L;
        long l2 = Globals.DB_Full_Backup_Duration_Val;
        switch (Globals.DB_Full_Backup_Duration_Type) {
            case "Hour": {
                l2 *= 3600L;
                break;
            }
            case "Day": {
                l2 *= 86400L;
                break;
            }
            case "Week": {
                l2 *= 604800L;
                break;
            }
            case "Month": {
                l2 *= 2592000L;
                break;
            }
            case "Year": {
                l2 *= 31536000L;
            }
        }
        if (l >= l2) {
            Periodic_DB_Ops.Encrypt_DB_Full_Backup();
        }
    }

    private void Take_Regular_Incremental_Backup() {
        if (!Globals.Periodic_Incremental_Backup_Enabled) {
            return;
        }
        Date date = null;
        Date date2 = new Date();
        String string = SQLiteHandler.Get_Var_Val_from_SysConf("Database", "Last_Incremental_BackupTime_S");
        if (string == null || string.isEmpty()) {
            date = Globals.String2Date(Globals.Add_Secs_Time_String(Globals.Get_Current_Date_Time(), -86400));
            string = Globals.Date2String(date);
        } else {
            date = Globals.String2Date(string);
        }
        long l = (date2.getTime() - date.getTime()) / 1000L;
        long l2 = Globals.DB_Incremental_Backup_Duration_Val;
        switch (Globals.DB_Incremental_Backup_Duration_Type) {
            case "Hour": {
                l2 *= 3600L;
                break;
            }
            case "Day": {
                l2 *= 86400L;
                break;
            }
            case "Week": {
                l2 *= 604800L;
                break;
            }
            case "Month": {
                l2 *= 2592000L;
                break;
            }
            case "Year": {
                l2 *= 31536000L;
            }
        }
        if (l >= l2) {
            Globals.Encrypt_DB_Incremental_Backup(string);
        }
    }

    private void Delete_DB_Regularly() {
        if (!Globals.Periodic_DB_Delete_Enabled) {
            return;
        }
        if (Periodic_DB_Ops.Encrypt_DB_Full_Backup()) {
            long l = Globals.DB_Cleanup_Duration_Val;
            switch (Globals.DB_Cleanup_Duration_Type) {
                case "Hour": {
                    l *= 3600L;
                    break;
                }
                case "Day": {
                    l *= 86400L;
                    break;
                }
                case "Week": {
                    l *= 604800L;
                    break;
                }
                case "Month": {
                    l *= 2592000L;
                    break;
                }
                case "Year": {
                    l *= 31536000L;
                }
            }
            String string = Globals.Add_Secs_Time_String(Globals.Get_Current_Date_Time(), (int)(l * -1L));
            Periodic_DB_Ops.CleanUp_DB_Till_Time(string);
        }
    }

    public static void CleanUp_DB_Till_Time(String string) {
        String string2 = Globals.DB_Source_Dir + "\\" + Globals.DB_Name + ".db";
        File file = new File(string2);
        String string3 = "";
        ArrayList arrayList = new ArrayList();
        String string4 = "Create_TS <= '" + string + "'";
        String string5 = "TimeStamp <= '" + string + "'";
        String string6 = "Transactions";
        String string7 = "Delete from " + string6 + " where " + string4;
        SQLiteHandler.RunQueryOnce(string7);
        string6 = "Account";
        string7 = "Delete from " + string6 + " where " + string5;
        SQLiteHandler.RunQueryOnce(string7);
        string6 = "AutoSaveTrans";
        string7 = "Delete from " + string6 + " where " + string5;
        SQLiteHandler.RunQueryOnce(string7);
        string6 = "MoneyTransaction";
        string7 = "Delete from " + string6 + " where " + string4;
        SQLiteHandler.RunQueryOnce(string7);
        if (!Globals.Force_Perioc_Incremental_Backup_Now) {
            String string8 = Globals.Get_Current_Date_Time();
            SQLiteHandler.InUp2_Sysconf_T("Database", "Last_DB_CleanUp_Time_S", string8);
        }
    }
}

