/*
 * Decompiled with CFR 0.152.
 */
package com.shasratech.vts;

import com.shasratech.vts.Globals;
import com.shasratech.vts.Main;
import com.shasratech.vts.SQLiteHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jssc.SerialPort;
import jssc.SerialPortException;

public class Serial_WB
extends Thread {
    byte[] buffer = null;
    private static int Final_Reading;
    private static int Final_Reading_Max;
    private static int ReadingEventCount;

    @Override
    public void run() {
        System.out.println("Starting Serail Read");
        int n = Globals.Get_BaudRate(Globals.WB_Baud_Rate) * 150 / 2400;
        if (Globals.WB_Present) {
            SerialPort serialPort = new SerialPort(Globals.WB_PortName);
            try {
                serialPort.openPort();
                System.out.println("Starting Serail Read Port Opened");
            }
            catch (SerialPortException serialPortException) {
                Logger.getLogger(Serial_WB.class.getName()).log(Level.SEVERE, null, serialPortException);
                System.out.println("Starting Serail Read Port Open Failed");
            }
            try {
                serialPort.setParams(Globals.Get_BaudRate(Globals.WB_Baud_Rate), Globals.Get_DataBits(Globals.WB_Data_Bits), Globals.Get_StopBits(Globals.WB_Stop_Bits), Globals.Get_Parity(Globals.WB_Parity));
                System.out.println("Starting Serail Read Port Params");
                while (Globals.serial_WB_T_Run_This_Thread) {
                    try {
                        Serial_WB.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger(Serial_WB.class.getName()).log(Level.SEVERE, null, interruptedException);
                    }
                    this.buffer = serialPort.readBytes(n);
                    if (Globals.Global_Debug) {
                        System.out.println("buffer len = " + this.buffer.length);
                        System.out.println("buffer = " + this.buffer.toString());
                    }
                    if (this.buffer != null) {
                        this.Process_WB_ReadData(this.buffer);
                        Globals.Serial_WB_Final_Reading = Final_Reading;
                        if (Main.myMainwindow != null && Main.myMainwindow.myTrans != null) {
                            Main.myMainwindow.myTrans.Update_WB_Load(Final_Reading);
                        }
                        if (Main.myMainwindow != null && Main.myMainwindow.myToken != null) {
                            Main.myMainwindow.myToken.Update_TE_TareWeight(Final_Reading);
                        }
                        if (Main.myMainwindow != null && Main.myMainwindow.mySysConf != null) {
                            Main.myMainwindow.mySysConf.Update_Data_into_Serial_Display(this.buffer, Final_Reading);
                        }
                        if (Final_Reading < 300) {
                            ReadingEventCount = 0;
                            if (Final_Reading_Max > 1000) {
                                Serial_WB.Trigger_AUtoSave_Transaction(Final_Reading_Max, 3, !Globals.DS_AS_S2_Entry);
                                Final_Reading_Max = 0;
                            }
                        }
                        if (Final_Reading <= Globals.AutoSaveTriggerWt) continue;
                        if (++ReadingEventCount == Globals.AutoSaveTriggerS1) {
                            Serial_WB.Trigger_AUtoSave_Transaction(Final_Reading, 1, !Globals.DS_AS_S2_Entry);
                        }
                        if (ReadingEventCount != Globals.AutoSaveTriggerS2) continue;
                        Serial_WB.Trigger_AUtoSave_Transaction(Final_Reading, 2, true);
                        continue;
                    }
                    Globals.Status_Bar_SetText("WeighBridge Reading:: Empty Buffer:: Unable to Read WeighBridge");
                }
            }
            catch (SerialPortException serialPortException) {
                Logger.getLogger(Serial_WB.class.getName()).log(Level.SEVERE, null, serialPortException);
                System.out.println("Starting Serail Read Port Set Params Failed");
                Globals.Status_Bar_SetText("  WeighBridge:: Starting Serail Read Port Set Params Failed");
            }
        }
    }

    private void Process_WB_ReadData(byte[] byArray) {
        int n = 1;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = byArray.length;
        if (bl2 || !Globals.WB_Present || n2 < 3) {
            return;
        }
        bl2 = true;
        block5 : switch (Globals.WB_Type) {
            case "WB_Type1": {
                int n3 = n2;
                int n4 = 0;
                char c = '\u0000';
                for (int i = 0; i < n3 && !bl; ++i) {
                    char c2 = (char)this.buffer[i];
                    if (c2 != Globals.WB_Ser_start_CharC) continue;
                    n4 = 0;
                    while (i < n3 && !bl) {
                        c = (char)this.buffer[i];
                        ++i;
                        if (c == ')') {
                            c = (char)this.buffer[i];
                            ++i;
                            if (c != '2') continue;
                            n = -1;
                            continue;
                        }
                        if (c == ' ') continue;
                        if (c >= '0' && c <= '9') {
                            n4 = n4 * 10 + (c - 48);
                            continue;
                        }
                        if (c != Globals.WB_Ser_End_CharC) break block5;
                        Final_Reading = n4;
                        Final_Reading *= n;
                        Final_Reading /= Globals.WB_Ser_Div_FactorI;
                        bl = true;
                        return;
                    }
                    break block5;
                }
                break;
            }
            case "WB_Type2": {
                int n5 = n2;
                int n6 = 0;
                char c = '\u0000';
                for (int i = 0; i < n5 && !bl; ++i) {
                    char c3 = (char)this.buffer[i];
                    if (c3 != Globals.WB_Ser_start_CharC) continue;
                    n6 = 0;
                    Final_Reading = 0;
                    while (i < n5 && !bl) {
                        c = (char)this.buffer[i];
                        ++i;
                        if (c >= '0' && c <= '9') {
                            n6 = n6 * 10 + (c - 48);
                            continue;
                        }
                        if (c != Globals.WB_Ser_End_CharC) continue;
                        Final_Reading = n6;
                        if (Final_Reading_Max < (Final_Reading *= n)) {
                            Final_Reading_Max = Final_Reading;
                        }
                        bl = true;
                        break block5;
                    }
                    break block5;
                }
                break;
            }
            case "WB_Type3": {
                int n7 = n2;
                int n8 = 0;
                int n9 = 0;
                char c = '\u0000';
                while (n8 < n7 && !bl) {
                    boolean bl3;
                    char c4 = (char)this.buffer[n8];
                    ++n8;
                    n9 = 0;
                    Final_Reading = 0;
                    int n10 = 0;
                    while (n8 < n7 && !bl) {
                        c = (char)this.buffer[n8];
                        ++n8;
                        if (c >= '0' && c <= '9') {
                            n9 = n9 * 10 + (c - 48);
                            ++n10;
                            continue;
                        }
                        if (n9 > 10000 || n10 > 5) {
                            Final_Reading = n9;
                            Final_Reading *= n;
                            bl = true;
                            break;
                        }
                        if (c != ' ') continue;
                    }
                    if (!(bl3 = false)) {
                        n9 = 0;
                        n10 = 0;
                        Final_Reading = 0;
                        bl3 = true;
                        continue;
                    }
                    bl3 = false;
                    Final_Reading = n9;
                    Final_Reading *= n;
                    bl = true;
                    break block5;
                }
                break;
            }
        }
    }

    private static void Trigger_AUtoSave_Transaction(int n, int n2, boolean bl) {
        int n3 = Globals.String2Int(SQLiteHandler.Get_Val_from_DB("AutoSaveTrans", "id", "max"));
        String string = Globals.Get_Current_Date_Time();
        String[] stringArray = new String[]{string, Integer.toString(++n3), Integer.toString(n), Integer.toString(n2), "0"};
        SQLiteHandler.InUp2_AutoSaveTrans(string, stringArray, bl);
    }

    static {
        ReadingEventCount = 0;
    }
}

