/*
 * Decompiled with CFR 0.152.
 */
package net.thegreshams.firebase4j.service;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.thegreshams.firebase4j.service.FirebaseException;
import net.thegreshams.firebase4j.service.FirebaseResponse;
import net.thegreshams.firebase4j.service.JacksonUtility;
import net.thegreshams.firebase4j.service.JacksonUtilityException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

public class Firebase {
    public static final String FIREBASE_API_JSON_EXTENSION = ".json";
    private final String baseUrl;
    private String secureToken = null;
    private List<NameValuePair> query;

    public Firebase(String string) throws FirebaseException {
        if (string == null || string.trim().isEmpty()) {
            String string2 = "baseUrl cannot be null or empty; was: '" + string + "'";
            throw new FirebaseException(string2);
        }
        this.baseUrl = string.trim();
        this.query = new ArrayList<NameValuePair>();
    }

    public Firebase(String string, String string2) throws FirebaseException {
        if (string == null || string.trim().isEmpty()) {
            String string3 = "baseUrl cannot be null or empty; was: '" + string + "'";
            throw new FirebaseException(string3);
        }
        this.secureToken = string2;
        this.baseUrl = string.trim();
        this.query = new ArrayList<NameValuePair>();
    }

    public FirebaseResponse get() throws FirebaseException, UnsupportedEncodingException {
        return this.get(null);
    }

    public FirebaseResponse get(String string) throws FirebaseException, UnsupportedEncodingException {
        String string2 = this.buildFullUrlFromRelativePath(string);
        HttpGet httpGet = new HttpGet(string2);
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpGet);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.GET, httpResponse);
        return firebaseResponse;
    }

    public FirebaseResponse patch(Map<String, Object> map) throws FirebaseException, JacksonUtilityException, UnsupportedEncodingException {
        return this.patch(null, map);
    }

    public FirebaseResponse patch(String string, Map<String, Object> map) throws FirebaseException, JacksonUtilityException, UnsupportedEncodingException {
        String string2 = this.buildFullUrlFromRelativePath(string);
        HttpPatch httpPatch = new HttpPatch(string2);
        httpPatch.setEntity((HttpEntity)this.buildEntityFromDataMap(map));
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpPatch);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.PATCH, httpResponse);
        return firebaseResponse;
    }

    public FirebaseResponse patch(String string) throws UnsupportedEncodingException, FirebaseException {
        return this.patch(null, string);
    }

    public FirebaseResponse patch(String string, String string2) throws UnsupportedEncodingException, FirebaseException {
        String string3 = this.buildFullUrlFromRelativePath(string);
        HttpPatch httpPatch = new HttpPatch(string3);
        httpPatch.setEntity((HttpEntity)this.buildEntityFromJsonData(string2));
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpPatch);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.PATCH, httpResponse);
        return firebaseResponse;
    }

    public FirebaseResponse put(Map<String, Object> map) throws JacksonUtilityException, FirebaseException, UnsupportedEncodingException {
        return this.put(null, map);
    }

    public FirebaseResponse put(String string, Map<String, Object> map) throws JacksonUtilityException, FirebaseException, UnsupportedEncodingException {
        String string2 = this.buildFullUrlFromRelativePath(string);
        HttpPut httpPut = new HttpPut(string2);
        httpPut.setEntity((HttpEntity)this.buildEntityFromDataMap(map));
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpPut);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.PUT, httpResponse);
        return firebaseResponse;
    }

    public FirebaseResponse put(String string) throws FirebaseException, UnsupportedEncodingException {
        return this.put(null, string);
    }

    public FirebaseResponse put(String string, String string2) throws FirebaseException, UnsupportedEncodingException {
        String string3 = this.buildFullUrlFromRelativePath(string);
        HttpPut httpPut = new HttpPut(string3);
        httpPut.setEntity((HttpEntity)this.buildEntityFromJsonData(string2));
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpPut);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.PUT, httpResponse);
        return firebaseResponse;
    }

    public FirebaseResponse post(Map<String, Object> map) throws JacksonUtilityException, FirebaseException, UnsupportedEncodingException {
        return this.post(null, map);
    }

    public FirebaseResponse post(String string, Map<String, Object> map) throws JacksonUtilityException, FirebaseException, UnsupportedEncodingException {
        String string2 = this.buildFullUrlFromRelativePath(string);
        HttpPost httpPost = new HttpPost(string2);
        httpPost.setEntity((HttpEntity)this.buildEntityFromDataMap(map));
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpPost);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.POST, httpResponse);
        return firebaseResponse;
    }

    public void Mypost(String string, Map<String, Object> map) throws JacksonUtilityException, FirebaseException, UnsupportedEncodingException {
        HttpPost httpPost = new HttpPost(string);
        httpPost.setEntity((HttpEntity)this.buildEntityFromDataMap(map));
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpPost);
    }

    public FirebaseResponse post(String string) throws FirebaseException, UnsupportedEncodingException {
        return this.post(null, string);
    }

    public FirebaseResponse post(String string, String string2) throws FirebaseException, UnsupportedEncodingException {
        String string3 = this.buildFullUrlFromRelativePath(string);
        HttpPost httpPost = new HttpPost(string3);
        httpPost.setEntity((HttpEntity)this.buildEntityFromJsonData(string2));
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpPost);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.POST, httpResponse);
        return firebaseResponse;
    }

    public Firebase addQuery(String string, String string2) {
        this.query.add((NameValuePair)new BasicNameValuePair(string, string2));
        return this;
    }

    public FirebaseResponse delete() throws FirebaseException, UnsupportedEncodingException {
        return this.delete(null);
    }

    public FirebaseResponse delete(String string) throws FirebaseException, UnsupportedEncodingException {
        String string2 = this.buildFullUrlFromRelativePath(string);
        HttpDelete httpDelete = new HttpDelete(string2);
        HttpResponse httpResponse = this.makeRequest((HttpRequestBase)httpDelete);
        FirebaseResponse firebaseResponse = this.processResponse(FirebaseRestMethod.DELETE, httpResponse);
        return firebaseResponse;
    }

    public StringEntity buildEntityFromDataMap(Map<String, Object> map) throws FirebaseException, JacksonUtilityException {
        String string = JacksonUtility.GET_JSON_STRING_FROM_MAP(map);
        return this.buildEntityFromJsonData(string);
    }

    private StringEntity buildEntityFromJsonData(String string) throws FirebaseException {
        StringEntity stringEntity = null;
        try {
            stringEntity = new StringEntity(string, "UTF-8");
        }
        catch (Throwable throwable) {
            String string2 = "unable to create entity from data; data was: " + string;
            throw new FirebaseException(string2, throwable);
        }
        return stringEntity;
    }

    private String buildFullUrlFromRelativePath(String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "";
        }
        if (!(string = string.trim()).isEmpty() && !string.startsWith("/")) {
            string = "/" + string;
        }
        String string2 = this.baseUrl + string + FIREBASE_API_JSON_EXTENSION;
        if (this.query != null) {
            string2 = string2 + "?";
            for (NameValuePair nameValuePair : this.query) {
                string2 = string2 + nameValuePair.getName() + "=" + URLEncoder.encode(nameValuePair.getValue(), "UTF-8") + "&";
            }
        }
        if (this.secureToken != null) {
            string2 = this.query != null ? string2 + "auth=" + this.secureToken : string2 + "?auth=" + this.secureToken;
        }
        if (string2.lastIndexOf("&") == string2.length()) {
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.deleteCharAt(stringBuilder.length());
            string2 = stringBuilder.toString();
        }
        return string2;
    }

    private HttpResponse makeRequest(HttpRequestBase httpRequestBase) throws FirebaseException {
        HttpResponse httpResponse = null;
        if (httpRequestBase == null) {
            String string = "request cannot be null";
            throw new FirebaseException(string);
        }
        try {
            DefaultHttpClient defaultHttpClient = new DefaultHttpClient();
            httpResponse = defaultHttpClient.execute((HttpUriRequest)httpRequestBase);
        }
        catch (Throwable throwable) {
            String string = "unable to receive response from request(" + httpRequestBase.getMethod() + ") @ " + httpRequestBase.getURI();
            throw new FirebaseException(string, throwable);
        }
        return httpResponse;
    }

    private FirebaseResponse processResponse(FirebaseRestMethod firebaseRestMethod, HttpResponse httpResponse) throws FirebaseException {
        Object object;
        Object object2;
        FirebaseResponse firebaseResponse = null;
        if (firebaseRestMethod == null) {
            String string = "method cannot be null";
            throw new FirebaseException(string);
        }
        if (httpResponse == null) {
            String string = "httpResponse cannot be null";
            throw new FirebaseException(string);
        }
        HttpEntity httpEntity = httpResponse.getEntity();
        int n = httpResponse.getStatusLine().getStatusCode();
        boolean bl = false;
        switch (firebaseRestMethod) {
            case DELETE: {
                if (httpResponse.getStatusLine().getStatusCode() != 204 || !"No Content".equalsIgnoreCase(httpResponse.getStatusLine().getReasonPhrase())) break;
                bl = true;
                break;
            }
            case PATCH: 
            case PUT: 
            case POST: 
            case GET: {
                if (httpResponse.getStatusLine().getStatusCode() != 200 || !"OK".equalsIgnoreCase(httpResponse.getStatusLine().getReasonPhrase())) break;
                bl = true;
                break;
            }
        }
        StringWriter stringWriter = new StringWriter();
        if (httpEntity != null) {
            try {
                int n2;
                object2 = httpEntity.getContent();
                char[] cArray = new char[1024];
                object = new BufferedReader(new InputStreamReader((InputStream)object2, "UTF-8"));
                while ((n2 = ((Reader)object).read(cArray)) != -1) {
                    ((Writer)stringWriter).write(cArray, 0, n2);
                }
            }
            catch (Throwable throwable) {
                String string = "unable to read response-content; read up to this point: '" + ((Object)stringWriter).toString() + "'";
                stringWriter = new StringWriter();
                throw new FirebaseException(string, throwable);
            }
        }
        object2 = null;
        try {
            object2 = JacksonUtility.GET_JSON_STRING_AS_MAP(((Object)stringWriter).toString());
        }
        catch (JacksonUtilityException jacksonUtilityException) {
            object = "unable to convert response-body into map; response-body was: '" + ((Object)stringWriter).toString() + "'";
            throw new FirebaseException((String)object, jacksonUtilityException);
        }
        firebaseResponse = new FirebaseResponse(bl, n, (Map<String, Object>)object2, ((Object)stringWriter).toString());
        this.query = null;
        return firebaseResponse;
    }

    public static enum FirebaseRestMethod {
        GET,
        PATCH,
        PUT,
        POST,
        DELETE;

    }
}

