/*
 * Decompiled with CFR 0.152.
 */
package net.thegreshams.firebase4j.service;

import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.thegreshams.firebase4j.service.JacksonUtilityException;
import org.codehaus.jackson.map.ObjectMapper;

public class JacksonUtility {
    public static String GET_JSON_STRING_FROM_MAP(Map<String, Object> map) throws JacksonUtilityException {
        if (map == null || map.isEmpty()) {
            return new String();
        }
        StringWriter stringWriter = new StringWriter();
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            objectMapper.writeValue((Writer)stringWriter, map);
        }
        catch (Throwable throwable) {
            String string = "unable to convert data from map into json: " + map.toString();
            throw new JacksonUtilityException(string);
        }
        return ((Object)stringWriter).toString();
    }

    public static Map<String, Object> GET_JSON_STRING_AS_MAP(String string) throws JacksonUtilityException {
        if (string == null || string.trim().isEmpty()) {
            return new HashMap<String, Object>();
        }
        string = string.trim();
        LinkedHashMap linkedHashMap = null;
        try {
            ObjectMapper objectMapper = new ObjectMapper();
            Object object = objectMapper.readValue(string, Object.class);
            if (object instanceof Map) {
                linkedHashMap = (LinkedHashMap)object;
            }
        }
        catch (Throwable throwable) {
            String string2 = "unable to map json-response: " + string;
            throw new JacksonUtilityException(string2, throwable);
        }
        if (linkedHashMap == null) {
            linkedHashMap = new LinkedHashMap();
        }
        return linkedHashMap;
    }
}

